"Macro Data Sheet file v. 1" 
gamesystem GURPS 
title "GURPS Fantasy Folk (v. 3.0.0)"

version 253
level 3

copyright "Copyright  1995, 2001 Steve Jackson Games Incorporated. All rights reserved. \
GURPS is a registered trademark of Steve Jackson Games Incorporated."

$$define PLUGIN FF
$$include gurps.inc

logo GURPS/FantasyFolk.lgo

datafile GURPSCompendium.cds end 

$$macro rs(name, value)
{{?opt:Base Level='$(value)';$(name);?zopt;}}
$$macro rsb(name, type, value)
{{?opt:Skill='$(name)';Racial Skill Bonus ($(type))=$(value);?zopt}}


cat Advantages
	sublist Races memlist

sublist "Fantasy Folk" memlist

$$race(Bale, 100, , ,
"Racial IQ=3;Racial HT=2;DR=3;Doesn't Eat or Drink;Hard to Kill=2;Immunity to Disease;\
Immunity to Poison;Injury Tolerance (No Blood);Metabolism Control=5;Regeneration;Temperature Tolerance;\
Unaging;Magery=1;?opt:Group='Magical';Group Skill Bonus=1",
"Bloodlust;?opt:Substance='Infrequent';Dependency[Dependency (Human Blood)];?clearopt;Fanaticism;Intolerance=2;?zopt;?opt:Racial Disadvantage;Megalomania;Paranoia;Sadism;Odious Personal Habit[Odious Racial Habit (Blood Drinker)]=3")
	opt
		begin add "Cost Adjustment" 4 noprint end
		begin adj "Racial Height" b_height+x;max_height+x ??6;6;x noprint dispexp "format('l: %+d in',o)" end
		end
$$race(Centaur, 65, , ,
"?opt:Upper=3;?opt:Lower=26;Split ST;?zopt;Quadruped Encumbrance;Racial IQ=-1;Racial HT=2;Alertness=1;DR=1;\
Enhanced Move=2;Extra Legs;Generic Advantage[Racial Skills]=11;\
?opt:Weight='(heightweight(height)+exbodyweight)*8';Racial Weight",
"Inconvenient Size;Overconfidence;Claustrophobia;Stubbornness",
"?opt:Base Level='IQ';Animal Handling;?zopt;?opt:Base Level='DX';Jumping;?zopt;?opt:Base Level='HT';Running;?zopt;?opt:Base Level='IQ';Survival (Plains)")
	opt
		begin adj "Racial Height" b_height+x;max_height+x ??8;8;x noprint dispexp "format('l: %+d in',o)" end
		end
$$race(Onocentaur, 55, , ,
"?opt:Upper=1;?opt:Lower=22;Split ST;?zopt;Quadruped Encumbrance;Racial HT=2;Acute Hearing=2;Alertness=1;\
Enhanced Move=2;Generic Advantage[Racial Skills]=2;Extra Legs;\
?opt:Weight='(heightweight(height)+exbodyweight)*8';Racial Weight",
"Claustrophobia;Social Stigma;Stubbornness;Unattractive",
"?opt:Base Level='IQ';Teamster")
	opt
		begin add "Cost Adjustment" ??-3 noprint end
		begin adj "Racial Height" b_height+x;max_height+x ??6;6;x noprint dispexp "format('l: %+d in',o)" end
		end
$$race(Dwarf, 40, , ,
"?allowdup;Racial ST=2;Racial Fatigue=2;DR=1;Extended Lifespan;Extra Encumbrance;Hard to Kill=1;Longevity;\
?opt:Group='Craft';Group Skill Bonus=3;?zopt;Generic Advantage[Racial Skills]=6",
"Greed;Miserliness;Reduced Move=1",
"?opt:Base Level='DX+1';Axe/Mace=10;?zopt;?opt:Base Level='IQ';Merchant=10",
"Quirk[Intolerance for Orcs];Quirk[Never Shave Beards];Quirk[Suspicious of Elves and Goblins]")
	opt
		begin adj "Racial Height" b_height+x;max_height+x ??-18 noprint dispexp "format('l: %+d in',o)" end
		begin adj "Racial Weight" b_weight+x ??+100 noprint dispexp "format('l: %+d lbs',o)" end
		end
$$race(Gnome, 25, Sk:Blacksmith-4;Sk:Armoury-4;Sk:Mechanic-4;Sk:Jeweler-4, ,
"DR=1;Racial Fatigue=1;Extended Lifespan;Extra Encumbrance;Hard to Kill=1;\
Longevity;?opt:Group='Craft';Small Group Skill Bonus=4",
"Reduced Move=1", ,
"Quirk[Do Not Like to Live Underground];Quirk[Never Forget a Favor or an Injury];Quirk[Trim Beards Close]")
	opt
		begin adj "Racial Height" b_height+x;max_height+x ??-24 noprint dispexp "format('l: %+d in',o)" end
		begin adj "Racial Weight" b_weight+x ??50 noprint dispexp "format('l: %+d lbs',o)" end
		end
$$race(Elf, 40, , , 
"?allowdup;Racial ST=-1;Racial DX=1;Racial IQ=1;Attractive;Combat Reflexes;Magery=1;Musical Ability=2;Unaging;\
?opt:Skill='Bard';Racial Skill Bonus (MA)=2;?zopt;?opt:Skill='Savoir-Faire';Racial Skill Bonus (ME)=2",
"Generic Disadvantage[Code of Honor -- Live Elegant Life]=-10;Sense of Duty[Sense of Duty (Nature)]=3")
	opt
		begin adj "Racial Height" b_height+x;max_height+x ??3 noprint dispexp "format('l: %+d in',o)" end
		begin adj "Racial Weight" b_weight+x ??-10 noprint dispexp "format('l: %+d lbs',o)" end
		end
$$race(Half-Elf, 30, , , Racial IQ=1;Extended Lifespan;Magery=1)
	opt
		begin adj "Racial Weight" b_weight+x ??-10 noprint dispexp "format('l: %+d lbs',o)" end
		end
$$race(Dark Elf, 30, , , 
"Racial ST=-1;Racial DX=1;Racial IQ=1;Attractive;Combat Reflexes;Magery=1;Musical Ability=2;Unaging;\
?opt:Skill='Bard';Racial Skill Bonus (MA)=2;?zopt;?opt:Skill='Savoir-Faire';Racial Skill Bonus (ME)=2",
"Code of Honor=2;Intolerance=2;Sense of Duty=3")
	opt
		begin adj "Racial Height" b_height+x;max_height+x ??3 noprint dispexp "format('l: %+d in',o)" end
		begin adj "Racial Weight" b_weight+x ??-10 noprint dispexp "format('l: %+d lbs',o)" end
		end
$$race("Dark Elf (Radical)", 25, , , 
"Racial ST=-1;Racial DX=1;Racial IQ=1;Attactive;Combat Reflexes;Magery=1;Musical Ability=2;Unaging;\
?opt:Skill='Bard';Racial Skill Bonus (MA)=2;?zopt;?opt:Skill='Savoir-Faire';Racial Skill Bonus (ME)=2",
"Code of Honor=2;Social Stigma=3;Sense of Duty=3")
	opt
		begin adj "Racial Height" b_height+x;max_height+x ??3 noprint dispexp "format('l: %+d in',o)" end
		begin adj "Racial Weight" b_weight+x ??-10 noprint dispexp "format('l: %+d lbs',o)" end
		end

$$race("Ellyllon (Royalty)", 30, , , 
"Racial ST=-5;Racial DX=3;Acute Hearing=2;Acute Vision=3;Appearance=2;Early Maturation;Extended Lifespan;\
?opt:Winged Flight='Large Wings';Flight;?zopt;Night Vision;Passive Defense=1;Ultrahearing;Winged Being Encumbrance;\
Generic Advantage[Racial Skills]=5;\
?opt:Height='round((max(round((min(64+max(st,5)+b_height-5,max_height+&max_height))*(1+m_height)),min_height)-(sex=2?2:0))/12)';Racial Height;\
?zopt;?opt:Weight=1.5;Racial Weight",
"Code of Honor;Fragile;Impulsiveness;\
?opt:Size='Under 2 feet tall';Inconvenient Size;?zopt;?cat:Advantages;Racial Hits=-4",
"?opt:Base Level='DX+1';Flight=0;?zopt;?opt:Base Level='IQ';Savoir-Faire=0;?zopt;\
?opt:Base Level='DX';Stealth=0")

$$race("Ellyllon", 20, , , 
"Racial ST=-5;Racial DX=3;Acute Hearing=2;Acute Vision=3;Appearance=2;\
?opt:Winged Flight='Large Wings';Flight;?zopt;Night Vision;Passive Defense=1;Ultrahearing;Winged Being Encumbrance;\
Generic Advantage[Racial Skills]=5;\
?opt:Height='round((max(round((min(64+max(st,5)+b_height-5,max_height+&max_height))*(1+m_height)),min_height)-(sex=2?2:0))/12)';Racial Height;\
?zopt;?opt:Weight=1.5;Racial Weight",
"Code of Honor;Fragile;Impulsiveness;\
?opt:Size='Under 2 feet tall';Inconvenient Size;?zopt;?cat:Advantages;Racial Hits=-4",
"?opt:Base Level='DX+1';Flight=0;?zopt;?opt:Base Level='IQ';Savoir-Faire=0;?zopt;\
?opt:Base Level='DX';Stealth=0")

$$race(Exalted Horse, 25, , ,
"?opt:No Fine Manipulators;Racial ST=18;?zopt;Racial HT=3;Acute Hearing=3;Acute Taste and Smell=3;Attractive;Blunt Teeth;Enhanced Move=2;\
Extra Legs;Peripheral Vision;Generic Advantage[Racial Skills]=4;\
?opt:Weight='stweight(~st)*8';Racial Weight;?zopt;\
?opt:Height='round((min(64+max(~st,5)+b_height-5,84)))';Racial Height",
"Bad Sight (Nearsightedness);Horizontal;Inconvenient Size;Mute;No Fine Manipulators;Poverty=3;Primitive=3;\
Social Stigma=2;Uneducated",
"?opt:Base Level='DX';Brawling;?zopt;?opt:Base Level='IQ';Gesture;?zopt;?opt:Base Level='HT-1';Running")

$$race(Faun, 25, , ,
"Racial ST=-2;Racial DX=3;Racial HT=1;Alertness=2;Animal Empathy;Musical Ability=2;Generic Advantage[Racial Skills]=3",
"Lecherousness;Reputation=1",
"?opt:Base Level='HT';Carousing=1;?zopt;?opt:Base Level='IQ';Scrounging=1")
	opt
		begin adj "Racial Height" b_height+x;max_height+x ??-8 noprint dispexp "format('l: %+d in',o)" end
		end

$$race(Fishman, 30, , ,
"Racial ST=1;Racial HT=2;Acute Taste and Smell=1;Amphibious;Dark Vision;DR=1;Gills;Nictating Membrane;\
Passive Defense=1;Pressure Support;Speak with Fish",
"Bad Sight (Nearsightedness);Cold-Blooded;?opt:Frequency='Daily';Dependency[Dependency (Water)];?zopt;?opt:Racial Disadvantage;\
Intolerance=2;Fanaticism;Odious Racial Habit[Odious Racial Habit (Eat Other Sentients)]=3;Reputation=4;\
Unattractive")
	opt
		begin adj "Racial Height" b_height+x;max_height+x ??4 noprint dispexp "format('l: %+d in',o)" end
		end

$$race(Gargoyle, 25, , ,
"Racial IQ=-1;Racial HT=2;Claws;DR=2;?opt:Winged Flight='Large Wings';Flight;?zopt;Night Vision;Winged Being Encumbrance",
"Cowardice;Gluttony;Laziness;Reputation[Reputation (Thieves and Bums)]=1;Ugly;Uneducated", ,
"Quirk[Bully]")
	opt
		begin adj "Racial Height" b_height+x;max_height+x ??-12 noprint dispexp "format('l: %+d in',o)" end
		end

$$race(Ghoul, -5, , ,
"Racial ST=2;Alertness=2;Double-Jointed;Immunity to Disease;Night Vision;Silence;\
Generic Advantage[Racial Skills]=5",
"?opt:Substance='Occasional';Dependency[Dependency (Fresh Brains)];?zopt;?opt:Racial Disadvantage;\
Odious Racial Habit[Odious Racial Habit (Eat Human Carrion)]=3;Reputation=4;\
Sense of Duty[Sense of Duty (Welfare of Race)=3;Ugly",
"$$rs(Camouflage, IQ+1)$$rs(Scrounging, IQ);$$rs(Stealth, DX)")
	opt
		begin adj "Racial Weight" b_weight+x ??-20 noprint dispexp "format('l: %+d lbs',o)" end
		end
$$race("Ghoul (Degenerate)", -15, , ,
"Racial ST=2;Racial IQ=-2;Alertness=2;Double-Jointed;Immunity to Disease;Night Vision;Silence;\
Generic Advantage[Racial Skills]=5",
"?opt:Substance='Occasional';Dependency[Dependency (Fresh Brains)];?zopt;?opt:Racial Disadvantage;\
Odious Racial Habit[Odious Racial Habit (Eat Human Carrion)]=3;Reputation=4;\
Sense of Duty[Sense of Duty (Welfare of Race)=3;Ugly",
"$$rs(Camouflage, IQ+1)$$rs(Scrounging, IQ);$$rs(Stealth, DX)")
	opt
		begin adj "Racial Weight" b_weight+x ??-20 noprint dispexp "format('l: %+d lbs',o)" end
		end

$$race(Giant, 180, , ,
"Racial ST=2;?opt:Base=12;Natural ST=13;?zopt;\
Racial DX=-1;Racial HT=4;Racial Hits=3;Acute Taste and Smell=3;DR=2;Enhanced Move=2;Extra Arm Length=1;\
High Pain Threshold;Passive Defense=1;\
?opt:Weight='stweight(~st)*4';Racial Weight;\
?zopt;?opt:Height='round((max(round(min(64+max(~st,5)+b_height-5,max_height+&max_height)*(1+m_height)),min_height)-(sex=2?2:0))*1.6)';Racial Height;?zopt",
"Bad Temper;Inconvenient Size;Shyness=2;Reputation=2;Stubbornness")
$$race(Huge Giant, 284, , ,
"?allowdup;Racial ST=4;?opt:Base=14;Natural ST=26;?zopt;\
Racial DX=-1;Racial HT=4;Acute Taste and Smell=3;DR=4;Enhanced Move=4;Racial Hits=6;Extra Arm Length=2;\
High Pain Threshold;Passive Defense=2;\
?opt:Weight='stweight(~st)*16';Racial Weight;\
?zopt;?opt:Height='round((max(round(min(64+max(~st,5)+b_height-5,max_height+&max_height)*(1+m_height)),min_height)-(sex=2?2:0))*1.6*2)';Racial Height;?zopt",
"Bad Temper;Inconvenient Size;Shyness=2;Reputation=2;Stubbornness")
$$race(Colossal Giant, 390, , ,
"?allowdup;Racial ST=6;?opt:Base=16;Natural ST=39;?zopt;\
Racial DX=-1;Racial HT=4;Acute Taste and Smell=3;DR=6;Enhanced Move=6;Racial Hits=12;Extra Arm Length=3;\
High Pain Threshold;Passive Defense=3;\
?opt:Weight='stweight(~st)*64';Racial Weight;\
?zopt;?opt:Height='round((max(round(min(64+max(~st,5)+b_height-5,max_height+&max_height)*(1+m_height)),min_height)-(sex=2?2:0))*1.6*3)';Racial Height;?zopt",
"Bad Temper;Inconvenient Size;Shyness=2;Reputation=2;Stubbornness")

$$race(Goblin, 5, , ,
"Racial ST=-2;Racial DX=1;Racial IQ=1;Night Vision",
"Impulsiveness")
	opt
		begin adj "Racial Weight" b_weight+x ??-20 noprint dispexp "format('l: %+d lbs',o)" end
		end
$$race(Hobgoblin, -25, , , 
"Racial ST=1;Racial DX=1;Racial IQ=-2;Night Vision",
"Bad Temper;Poverty=3;Stubbornness")

$$race(Great Eagle, 25, , ,
"Racial ST=3;Racial DX=2;Racial HT=2;Acute Vision=1;Claws;\
?opt:Winged Flight='Large Wings';Flight;?zopt;Peripheral Vision;Sharp Teeth;Telescopic Vision;Winged Being Encumbrance;\
Generic Advantage[Racial Skills]=2;\
?opt:Weight='stweight(st)-50';Racial Weight;?zopt;\
?opt:Height='round((min(64+max(st,5)+b_height-5,84)))*2';Racial Height[Racial Wing Span]",
"Bloodlust;Compulsive Behavior[Compulsive Behavior (Seeks Solitude)]=3;Fragile;Intolerance=2;Mute;\
Poverty=3;Primitive=3",
"$$rs(Flight, DX+1)")

$$race(Halfling, 10/5, , ,
"Racial ST=-3;Racial DX=1;Racial HT=1;Reputation[Reputation (Good Neighbors)]=1;Silence=1;\
Generic Advantage[Racial Skill]=4;?allowdup;$$rsb(Bow, PH, 2);?allowdup;$$rsb(Sling, PH, 2);?allowdup;$$rsb(Throwing, PH, 2)",
"Code of Honor[Code of Honor (Hospitality)]=1;Gluttony;Reduced Move=1;Addiction[Addiction: Tobacco]",
"$$rs(Stealth, DX+1)", "Quirk[Dislike Traveling by Water]")
	opt
		begin adj "Racial Height" b_height+x;max_height+x ??-18 noprint dispexp "format('l: %+d in',o)" end
		end

$$race(Insect Man, 38, , ,
"Racial ST=1;Racial HT=1;DR=2;Passive Defense=1;Secret Communication",
"Mute;Sterile;Unattractive", , "Quirk{Secretive]")

$$race(Kobold, -30, , ,
"Racial ST=-2;Racial DX=1;Racial IQ=-2;Cast Iron Stomach",
"Short Attention Span;Uneducated;Weak Will", ,
"Quirk[Loves Practical Jokes];Quirk[Easily Offended]")

$$race(Leprechaun, 5, , ,
"Racial ST=-4;Racial DX=2;Racial Hits=-2;Acute Hearing=1;Longevity;Luck;Magery=1;Musical Ability=1;Night Vision;\
Generic Advantage[Racial Skill]=2;\
?opt:Height='round((max(round((min(64+max(~st,5)+b_height-5,max_height+&max_height))*(1+m_height)),min_height)-(sex=2?2:0))/6)';Racial Height;\
?zopt;?opt:Weight=12;Racial Weight",
"?opt:Size='Under 2 feet tall';Inconvenient Size;?zopt;?opt:Racial Disadvantage;Miserliness",
"$$rs(Leatherworking,IQ+1)")

$$race(Merfolk, 40, amphibious+1, ,
"Enhanced Move (Swimming)=2;Gills;?opt:Up to='100normal';Pressure Support;?zopt;Sonar Vision;\
?opt:Weight='round((heightweight(height)+b_weight+incdensity-(sex=2?10:0))*1.3)';Racial Weight",
"?opt:Frequency='Daily';Dependency[Dependency (Water)];?zopt")

$$race(Dolphin, 30, , ,
"?opt:No Fine Manipulators;Racial ST=4;?opt:Base=14;?opt:No Fatigue Bonus=1;?allowdup;Racial ST=2;?zopt;Racial DX=2;Racial HT=2;\
Alertness=3;Absolute Direction;Blunt Teeth;Enhanced Move (Swimming)=2;Nictating Membrane;\
Peripheral Vision;?opt:Up to='100normal';Pressure Support;?zopt;Sonar Vision;\
Generic Advantage[Racial Skills]=5",
"?opt:Frequency='Hourly';Dependency[Dependency (Water)];?zopt;?opt:Racial Disadvantage;Impulsiveness;Mute;No Manipulators;\
Primitive=3;Short Lifespan=2",
"$$rs(Acrobatics, DX);$$rs(Gesture,IQ)")

$$race(Minotaur, 75, , ,
"Racial ST=3;Racial DX=1;Racial IQ=-2;Racial HT=3;Absolute Direction;Acute Hearing=3;DR=3;Long Tusks;\
Magic Resistance=3;Peripheral Vision;Skull DR=2;Generic Advantage[Racial Skill]=1",
"Berserk;Bloodlust;Hideous;Intolerance=2;Odious Racial Habit[Odious Racial Habit (Eat Other Sentients)]=3;\
Uneducated",
"$$rs(Brawling,DX)")


$$race(Ogre, 95, , ,
"Racial ST=2;?opt:Base=12;Natural ST=8;?zopt;\
Racial DX=-2;Racial IQ=-3;Racial HT=4;Acute Taste and Smell=1;DR=3;High Pain Threshold;Magic Resistance=2;\
Night Vision;Passive Defense=1;Generic Advantage[Racial Skill]=1;\
?opt:Weight='stweight(~st)*5';Racial Weight;?zopt;\
?opt:Height='round((max(round(min(64+max(~st,5)+b_height-5,max_height+&max_height)*(1+m_height)),min_height)-(sex=2?2:0))*1.6)';Racial Height;?zopt",
"Hideous;Inconvenient Size;Odious Racial Habit[Odious Racial Habit (Eat Other Sentients)]=3;Uneducated",
"$$rs(Brawling, DX)")

$$race(Half Ogre, 45, , ,
"Racial ST=2;?opt:Base=12;Natural ST=4;?zopt;\
Racial DX=-1;Racial IQ=-3;Racial HT=2;Acute Taste and Smell=1;Alertness=1;DR=2;Racial Hits=2;High Pain Threshold;\
Magic Resistance=1;Night Vision;\
?opt:Weight='stweight(st)*2';Racial Weight;?zopt",
"Intolerance=2;Ugly;Odious Racial Habit[Odious Racial Habit (Eat Other Sentients)]=3;Uneducated")


$$race(Orc, -10, , ,
"Racial IQ=-2;Racial HT=2;Acute Hearing=2;Racial Hits=1;Generic Advantage[Racial Skill]=1",
"Intolerance=2;Reputation=3",
"$$rs(Brawling, DX)")
	opt
		begin adj "Racial Height" b_height+x;max_height+x ??-2 noprint dispexp "format('l: %+d in',o)" end
		begin adj "Racial Weight" b_weight+x ??+10 noprint dispexp "format('l: %+d lbs',o)" end
		end
$$race(Half Orc, 0, , ,
"Racial IQ=-1;Racial HT=1;Acute Hearing=2;Racial Hits=1;Generic Advantage[Racial Skill]=1",
"Reputation=2",
"$$rs(Brawling, DX)")
	opt
		begin adj "Racial Weight" b_weight+x ??+10 noprint dispexp "format('l: %+d lbs',o)" end
		end

$$race(Reptile Man, 75, , ,
"Racial ST=4;Racial IQ=-1;Racial HT=2;Claws;DR=1;Longevity;Peripheral Vision;Sharp Teeth;Temperature Tolerance=5;\
Generic Advantage[Racial Skills]=3",
"Intolerance=2;Reputation=3;Shyness",
"$$rs(Camouflage,IQ);?opt:Base Level='IQ';Survival (Desert);?zopt",
"Quirk[Inscrutable]")
	opt
		begin adj "Racial Weight" b_weight+x ??30 noprint dispexp "format('l: %+d lbs',o)" end
		end

$$race(Wildman, 35, , , 
"Racial DX=1;Racial HT=2;Alertness=2;Animal Empathy;Danger Sense;DR=2;Mimicry;Passive Defense=1;Silence=1;\
Generic Advantage[Racial Skills]=9",
"Code of Honor[Code of Honor (Protect the Wild)]=2;Pacifism (Self-Defense Only);Poverty=2;Primitive=3;\
Shyness=2;Truthfulness;Vow[Vow (No Technology)]=4",
"$$rs(Camouflage,IQ);$$rs(Stealth, DX);?opt:Base Level='IQ';Survival (Woodlands);?zopt")
	opt
		begin adj "Racial Height" b_height+x;max_height+x ??-8 noprint dispexp "format('l: %+d in',o)" end
		end

$$race(Sasquatch, 60, , ,
"Racial ST=3;Racial DX=1;Racial IQ=-1;Racial HT=2;Alertness=2;Animal Empathy;Danger Sense;DR=3;\
Passive Defense=1;Silence=1;Generic Advantage[Racial Skills]=6",
"Odious Racial Habit[Odious Racial Habit (Smell Bad)]=2;Pacifism (Self-Defense Only);Poverty=2;Primitive=3;Shyness=2",
"$$rs(Camouflage,IQ+1);$$rs(Stealth, DX);$$rs(Survival, IQ)")
	opt
		begin adj "Racial Weight" b_weight+x ??50 noprint dispexp "format('l: %+d lbs',o)" end
		end

$$race(Winged Folk, 50, , ,
"Racial ST=1;Racial DX=2;Acute Vision=3;?opt:Winged Flight='Large Wings';Flight;?zopt;Winged Being Encumbrance;\
Generic Advantage[Racial Skill]=4",
"Fragile",
"$$rs(Bolas, DX);$$rs(Flight, DX+1)")
	opt
		begin adj "Racial Height" b_height+x;max_height+x ??-3 noprint dispexp "format('l: %+d in',o)" end
		begin adj "Racial Weight" b_weight+x ??-10 noprint dispexp "format('l: %+d lbs',o)" end
		end

end
end
end

end
